﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SC290
{
    public partial class MyChannelControl : UserControl
    {
        public uint m_nChannelNumber = 0;

        public MyChannelControl()
        {
            InitializeComponent();
        }

        protected override void WndProc(ref Message m)
        {
            if (m.Msg == 0x0201) // WM_LBUTTONDOWN
            {
                Form1 Parent = (Form1)this.Parent;

                Parent.OnLButtonDown_ChannelControl(m_nChannelNumber);
            }

            if (m.Msg == 0x14) // WM_ERASEBKGND
            {
                Form1 Parent = (Form1)this.Parent;

                if ((m_nChannelNumber & 0x1000000) == 0x1000000) // LIVE PATH
                {
                    if ((Parent.m_hVideoDev[m_nChannelNumber - 0x1000000] & 0x8000000) != 0x8000000) { return; }
                }

                if ((m_nChannelNumber & 0x2000000) == 0x2000000) // FILE STREAM PATH
                {
                    if ((Parent.m_hVideoDev[m_nChannelNumber - 0x2000000] & 0x8000000) != 0x8000000) { return; }                    
                }

                if ((m_nChannelNumber & 0x4000000) == 0x4000000) // H.264 MAIN.STREAM PATH
                {
                    if ((Parent.m_hVideoDev[m_nChannelNumber - 0x4000000] & 0x8000000) != 0x8000000) { return; }                    
                }

                if ((m_nChannelNumber & 0x8000000) == 0x8000000) // H.264 SUB.STREAM PATH
                {
                    if ((Parent.m_hVideoDev[m_nChannelNumber - 0x8000000] & 0x8000000) != 0x8000000) { return; }
                }
            }
            
            base.WndProc(ref m);
        }
    }
}
